!to "flapper.prg",cbm

*=$0801

BSOUT = $ffd2

TOP_END
          !byte $0C
BOTTOM_END          
          !byte $08
BUTTON_RELEASED          
          !byte $0A
CLEFT_POS          
          !byte $00,$9E,$20,$32,$30,$36,$34,$00,$00,$00,$00,$00

          lda #7
          sta 53248 + 37
          lda #2
          sta 53248 + 39

          jsr ClearScreen

          jmp TitleScreen

SIZE_CHANGE_TABLE
          !byte 0,1,1,2,2,3,3,4

GRAVITY_DOWN_SPEED = $d0
SOFTSCROLL_COUNTER = $80c
          
CHAR_SPACE 
          !byte 32

FILL_CHAR
          !byte CHAR_ROCK

TEXT_FLEW
          !text "YOU FLEW         M"
          !byte 0

GRAVITY_CURRENT_POS
          !byte 128
SOUND_CURRENT_POS
          !byte 128

MIN_CLEFT_SIZE          
          !byte 8

*=$840            
!binary "flapper.spr"

;modified charset
          ;rock
          !byte 255,$bf,255,255,255,$fb,255,255
          ;space
          !byte 0,0,0,0,0,0,0,0

StartGame
          lda #1
          sta 53248 + 21      ;enable sprite 0
          sta 53248 + 38      ;multicolor 1
          sta 53248 + 28      ;sprite multicolor
          sta TOP_END
          
          lda #100
          sta 53248 + 0
          sta 53248 + 1
            
          lda #32
          sta GRAVITY_DOWN_SPEED
          lda #128
          sta GRAVITY_CURRENT_POS
          lda #24
          sta BOTTOM_END

          lda #18
          sta 53272

          ;initialize sound
          lda #0
          sta 54272
          lda #10
          sta 54272+1
          lda #04
          sta 54272+5
          lda #$19
          sta 54272+6
          lda #15
          sta 54272+24
          
          ;clear screen
          jsr ClearScreen
          
          lda $d01f
          
          ldy #7
          lda #48
.EmptyDistance
          sta FLOWN_DISTANCE,y
          dey
          cpy #$ff
          bne .EmptyDistance
          
doscroll

;---- Softscroll Bereich
          DEC SOFTSCROLL_COUNTER
          LDA SOFTSCROLL_COUNTER
          AND #%00000111  ;Alle Bits3-7 auf 0, BIT0-2 unangestastet lassen.
          STA 53270
  
;----- hard scroll needed?
          CMP #7
          beq .DoHardScroll
          jmp NoHardScroll

;----- Hardscrolling
.DoHardScroll
          LDX #0
loop  
          LDA $0401,x
          STA $0400,x
          INX   ;X erh�hen
          BNE loop  ;alle 40 durch, wenn nicht dann nochal zu Label: LOOP
loop1  
          LDA $0501,x
          STA $0500,x
          INX   ;X erh�hen
          BNE loop1  ;alle 40 durch, wenn nicht dann nochal zu Label: LOOP
loop2  
          LDA $0601,x
          STA $0600,x
          INX   ;X erh�hen
          BNE loop2  ;alle 40 durch, wenn nicht dann nochal zu Label: LOOP
loop3  
          LDA $0701,x
          STA $0700,x
          INX   ;X erh�hen
          CPX #232   ;das ganze 40mal, f�r 40 Textzeichen = 1 Textzeile!
          BNE loop3  ;alle 40 durch, wenn nicht dann nochal zu Label: LOOP

;------ neuen Buchstaben holen nach Hardscroll

          ;prepare pointer to top right screen position
          lda #$04
          sta $f3
          lda #$27
          sta $f2
          
          ldx #0
          ldy #0
.FillTopLoop
          lda FILL_CHAR
          sta ($f2),y
      
          lda $f2
          clc
          adc #40
          sta $f2
          lda #0
          lda $f3
          adc #0
          sta $f3
      
          inx
          cpx TOP_END
          beq .EmptyChar
          cpx BOTTOM_END
          beq .FullChar
          cpx #25
          beq .NewColumnDone
          jmp .FillTopLoop

.EmptyChar
          lda CHAR_SPACE
          sta FILL_CHAR
          jmp .FillTopLoop

.FullChar
          lda #CHAR_ROCK
          sta FILL_CHAR
          jmp .FillTopLoop

.NewColumnDone

.CheckTopBorder
          jsr random_number
          
          lda TOP_END
          clc
          adc SIZE_CHANGE_TABLE,x
          sec
          sbc #2
          sta TOP_END
          cmp #220
          bcs .TopUnderflow
          cmp #1
          bcc .TopUnderflow
          
          lda BOTTOM_END
          sec
          sbc TOP_END
          cmp MIN_CLEFT_SIZE
          bcs .CheckBottomBorder
          
          ;too small, set to sane value
          lda BOTTOM_END
          sec
          sbc MIN_CLEFT_SIZE
          sta TOP_END
          jmp .CheckBottomBorder
          
          
.TopUnderflow
          lda #1
          sta TOP_END
          
.CheckBottomBorder
          jsr random_number
          
          lda BOTTOM_END
          clc
          adc SIZE_CHANGE_TABLE,x
          sec
          sbc #2
          sta BOTTOM_END
          cmp #24
          bcs .BottomOverflow
          
          lda BOTTOM_END
          sec
          sbc TOP_END
          cmp MIN_CLEFT_SIZE
          bcs .BorderChangesDone
          
          ;too small, set to sane value
          lda TOP_END
          clc
          adc MIN_CLEFT_SIZE
          sta BOTTOM_END
          jmp .BorderChangesDone
          
          
.BottomOverflow
          lda #23
          sta BOTTOM_END
          
.BorderChangesDone

NoHardScroll
          lda GRAVITY_DOWN_SPEED
          cmp #32 + 32
          beq .AlreadyHighestDown
          inc GRAVITY_DOWN_SPEED
          
.AlreadyHighestDown          
          lda GRAVITY_CURRENT_POS
          clc
          adc GRAVITY_DOWN_SPEED
          sec
          sbc #32
          sta GRAVITY_CURRENT_POS
          cmp #160
          bpl .GoDown
          cmp #96
          bmi .GoUp
          
          jmp .CheckPlayerPos

.GoDown
          inc 53248 + 1
          
.GoOnDown          
          lda GRAVITY_CURRENT_POS
          sec
          sbc #32
          sta GRAVITY_CURRENT_POS
          jmp .CheckPlayerPos

.GoUp
          dec 53248 + 1

          lda GRAVITY_CURRENT_POS
          clc
          adc #32
          sta GRAVITY_CURRENT_POS
          
.CheckPlayerPos          
          ;check sprite top/bottom position
          lda 53248 + 1
          cmp #221
          beq .PlayerTooLow
          cmp #54
          beq .PlayerTooHigh
          jmp .CheckJoystick
          
.PlayerTooLow
          lda #220
          jmp .CheckJoystick
          
.PlayerTooHigh
          lda #55
          
.CheckJoystick          
          sta 53248 + 1
          
          lda #$10
          bit 56320
          bne .NoButtonPressed
          
          lda BUTTON_RELEASED
          bne .NextFrame
          
          lda #1
          sta BUTTON_RELEASED
          
          lda GRAVITY_DOWN_SPEED
          sec
          sbc #16
          bmi .MakeNull
          jmp .Store
          
.MakeNull
          lda #0
.Store          
          sta GRAVITY_DOWN_SPEED
          
          jmp .NextFrame

.NoButtonPressed

          lda #0
          sta BUTTON_RELEASED

.NextFrame

          lda #96
          sec
          sbc GRAVITY_DOWN_SPEED
          clc
          adc SOUND_CURRENT_POS
          sta SOUND_CURRENT_POS
          bcc .NoFlap
          
          jsr flap_sound

          ;toggle between #33 and #34
          lda 2040
          eor #$03
          sta 2040
          
.NoFlap
          
.SpriteAnimationDone          

          ;player collided with wall?
          lda $D01F 
          bne .PlayerDead
          lda $d01f
          
          ;inc distance counter
          ldx #7
          
.NextDistance          
          inc FLOWN_DISTANCE,x
          lda FLOWN_DISTANCE,x
          cmp #58
          bne .DistanceDone
          
          lda #48
          sta FLOWN_DISTANCE,x
          dex
          cpx #5
          bne .NoCleftUpdate
          
          dec MIN_CLEFT_SIZE
          lda MIN_CLEFT_SIZE
          ora #$5
          sta MIN_CLEFT_SIZE
          
.NoCleftUpdate          
          jmp .NextDistance
          
.DistanceDone          
          jsr WAITFRAME
          jmp doscroll

WAITFRAME 
          LDA $D012
          CMP #$Ff
          BEQ WAITFRAME

WAITFR2  
          LDA $D012
          CMP #$Ff
          BNE WAITFR2
          rts

.PlayerDead
          ;longer flap sound for explosion
          lda #$29
          sta 54272+6
          lda #$1d
          sta 54272+5
          jsr flap_sound
          
          lda #35
          sta 2040
          
          ldx #200
.DeathDelay          
          jsr WAITFRAME
          dex
          bne .DeathDelay
          
          lda #32
          sta CHAR_SPACE
          jsr ClearScreen
          lda #21
          sta 53272
          
          lda #$08
          STA 53270
          
          lda #0
          sta 53248+21

          ldx #04           ; Zeile 3
          ldy #10           ; Spalte 10
          lda #<TEXT_FLEW
          sta $fb
          lda #>TEXT_FLEW
          sta $fc
          jsr DisplayText
          
          ;display distance
          ldy #8
.DisplayLoop          
          lda FLOWN_DISTANCE-1,y
          sta 1024+19+4*40-1,y
          dey
          bne .DisplayLoop
          
!zone TitleScreen          
TitleScreen          

          ldx #08
          ldy #09
          lda #<TEXT_BUTTON
          sta $fb
          lda #>TEXT_BUTTON
          sta $fc
          jsr DisplayText

          lda #33
          sta CHAR_SPACE 

          lda #0
          sta 53280
          sta 53281

.NoButtonPressed
          lda 56320
          and #$10
          bne .NoButtonPressed
          
          jmp StartGame
          
DisplayText
          clc               ; set cursor
          jsr $fff0         ; now

          ldy #$00
.TextDisplayLoop  
          lda ($fb),y
          beq .TextDisplayDone
          jsr BSOUT         ; display text until 00
          iny
          jmp .TextDisplayLoop  
          
.TextDisplayDone
          rts
          
flap_sound
          lda #0
          sta 54272+4
          
          lda #129
          sta 54272+4
          rts

random_number
          lda $dc04
          eor $dc05
          eor $dd04
          adc $dd05
          eor $dd06
          eor $dd07
          
          and #$07
          tax
          rts

ClearScreen
          lda #$00             ; $fc/$fb = $0400 = Bildschirmspeicher
          sta $fb
          lda #$04
          sta $fb+1
          lda #$00             ; $fc/$fb = $0400 = Bildschirmspeicher
          sta $f9
          lda #$d8
          sta $f9+1

          ldx #4                ; 4 blocks (4 * 256 bytes)

          ldy #$00                                    

schleife   
          lda CHAR_SPACE        ; fill char = space
          sta ($fb), Y
          lda #8
          sta ($f9), Y
          iny
          bne schleife

          inc $fb+1             ; next block of screen
          inc $f9+1
          dex
          bne schleife
          rts
          


CHAR_ROCK = 24+8

FLOWN_DISTANCE = $4000

          
TEXT_BUTTON
          !text "FLAPPER - PRESS BUTTON"
          !byte 0



